<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use TCG\Voyager\Models\DataRow;

class DataRowsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {

        DataRow::truncate();


        DataRow::insert(array (
            array (
                'id' => 1,
                'data_type_id' => 1,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'ID',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 1,
            ),
            array (
                'id' => 2,
                'data_type_id' => 1,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 2,
            ),
            array (
                'id' => 3,
                'data_type_id' => 1,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'Email',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 3,
            ),
            array (
                'id' => 4,
                'data_type_id' => 1,
                'field' => 'password',
                'type' => 'password',
                'display_name' => 'Password',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 1,
                'add' => 1,
                'delete' => 0,
                'details' => NULL,
                'order' => 4,
            ),
            array (
                'id' => 5,
                'data_type_id' => 1,
                'field' => 'remember_token',
                'type' => 'text',
                'display_name' => 'Remember Token',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 5,
            ),
            array (
                'id' => 6,
                'data_type_id' => 1,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 6,
            ),
            array (
                'id' => 7,
                'data_type_id' => 1,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 7,
            ),

            array (
                'id' => 8,
                'data_type_id' => 1,
                'field' => 'avatar',
                'type' => 'image',
                'display_name' => 'Avatar',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 8,
            ),
            array (
                'id' => 9,
                'data_type_id' => 1,
                'field' => 'user_belongsto_role_relationship',
                'type' => 'relationship',
                'display_name' => 'Role',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 0,
                'details' => '{"model":"TCG\\\\Voyager\\\\Models\\\\Role","table":"roles","type":"belongsTo","column":"role_id","key":"id","label":"display_name","pivot_table":"roles","pivot":0}',
                'order' => 10,
            ),
            array (
                'id' => 10,
                'data_type_id' => 1,
                'field' => 'user_belongstomany_role_relationship',
                'type' => 'relationship',
                'display_name' => 'voyager::seeders.data_rows.roles',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 0,
                'details' => '{"model":"TCG\\\\Voyager\\\\Models\\\\Role","table":"roles","type":"belongsToMany","column":"id","key":"id","label":"display_name","pivot_table":"user_roles","pivot":"1","taggable":"0"}',
                'order' => 11,
            ),
            array (
                'id' => 11,
                'data_type_id' => 1,
                'field' => 'settings',
                'type' => 'hidden',
                'display_name' => 'Settings',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 12,
            ),
            array (
                'id' => 12,
                'data_type_id' => 2,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'ID',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 1,
            ),
            array (
                'id' => 13,
                'data_type_id' => 2,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 2,
            ),
            array (
                'id' => 14,
                'data_type_id' => 2,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 3,
            ),
            array (
                'id' => 15,
                'data_type_id' => 2,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 4,
            ),
            array (
                'id' => 16,
                'data_type_id' => 3,
                'field' => 'id',
                'type' => 'number',
                'display_name' => 'ID',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 1,
            ),
            array (
                'id' => 17,
                'data_type_id' => 3,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 2,
            ),
            array (
                'id' => 18,
                'data_type_id' => 3,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 3,
            ),
            array (
                'id' => 19,
                'data_type_id' => 3,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => NULL,
                'order' => 4,
            ),
            array (
                'id' => 20,
                'data_type_id' => 3,
                'field' => 'display_name',
                'type' => 'text',
                'display_name' => 'Display Name',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 5,
            ),
            array (
                'id' => 21,
                'data_type_id' => 1,
                'field' => 'role_id',
                'type' => 'text',
                'display_name' => 'Role',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => NULL,
                'order' => 9,
            ),
            array (
                'id' => 22,
                'data_type_id' => 4,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 23,
                'data_type_id' => 4,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Türü',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"1":"\\u00c7al\\u0131\\u015fan","2":"\\u0130\\u015fveren"}}',
                'order' => 2,
            ),
            array (
                'id' => 24,
                'data_type_id' => 4,
                'field' => 'firstname',
                'type' => 'text',
                'display_name' => 'Adı',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"\\u0130\\u015fveren ise sadece bu alan, \\u00c7al\\u0131\\u015fanda Ad ve Soyad doldurulmal\\u0131d\\u0131r."}',
                'order' => 3,
            ),
            array (
                'id' => 25,
                'data_type_id' => 4,
                'field' => 'surname',
                'type' => 'text',
                'display_name' => 'Soyadı',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 26,
                'data_type_id' => 4,
                'field' => 'email',
                'type' => 'text',
                'display_name' => 'E-Posta Adresi',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 27,
                'data_type_id' => 4,
                'field' => 'password',
                'type' => 'password',
                'display_name' => 'Şifre',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            array (
                'id' => 28,
                'data_type_id' => 4,
                'field' => 'phone',
                'type' => 'text',
                'display_name' => 'Telefon Numarası',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 29,
                'data_type_id' => 4,
                'field' => 'lang',
                'type' => 'text',
                'display_name' => 'Kullanıcı Dili',
                'required' => 1,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            array (
                'id' => 30,
                'data_type_id' => 4,
                'field' => 'active',
                'type' => 'select_dropdown',
                'display_name' => 'Durumu',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"0":"Pasif","1":"Aktif"}}',
                'order' => 9,
            ),
            array (
                'id' => 31,
                'data_type_id' => 4,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Eklenme Tarihi',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            array (
                'id' => 32,
                'data_type_id' => 4,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 11,
            ),
            array (
                'id' => 33,
                'data_type_id' => 4,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Silinme Zamanı',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 12,
            ),
            array (
                'id' => 34,
                'data_type_id' => 5,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 35,
                'data_type_id' => 5,
                'field' => 'key',
                'type' => 'text',
                'display_name' => 'Başlık',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            array (
                'id' => 36,
                'data_type_id' => 5,
                'field' => 'value',
                'type' => 'rich_text_box',
                'display_name' => 'Sözleşme Metni',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            array (
                'id' => 37,
                'data_type_id' => 5,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Eklenme Tarihi',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 38,
                'data_type_id' => 5,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 39,
                'data_type_id' => 6,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 40,
                'data_type_id' => 6,
                'field' => 'key',
                'type' => 'text',
                'display_name' => 'Key',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{"slugify":{"origin":"value","forceUpdate":true}}',
                'order' => 3,
            ),
            array (
                'id' => 41,
                'data_type_id' => 6,
                'field' => 'value',
                'type' => 'text',
                'display_name' => 'Meslek',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            array (
                'id' => 42,
                'data_type_id' => 7,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 43,
                'data_type_id' => 7,
                'field' => 'type',
                'type' => 'select_dropdown',
                'display_name' => 'Hangi Alan',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"calisan","options":{"calisan":"\\u00c7al\\u0131\\u015fan","isveren":"\\u0130\\u015fveren"}}',
                'order' => 2,
            ),
            array (
                'id' => 44,
                'data_type_id' => 7,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'Başlık',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            array (
                'id' => 45,
                'data_type_id' => 7,
                'field' => 'video_link',
                'type' => 'file',
                'display_name' => 'Video Dosyası',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Video, editlenmi\\u015f bir \\u015fekilde y\\u00fcklenmesi laz\\u0131m. Dosya boyutu azalt\\u0131lm\\u0131\\u015f \\u015fekilde olmal\\u0131d\\u0131r. Maksimum boyut 25 MB"}',
                'order' => 4,
            ),
            array (
                'id' => 46,
                'data_type_id' => 7,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Eklenme Tarihi',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 47,
                'data_type_id' => 7,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 6,
            ),
            array (
                'id' => 48,
                'data_type_id' => 7,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Silinme Zamanı',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 62,
                'data_type_id' => 9,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 63,
                'data_type_id' => 9,
                'field' => 'name',
                'type' => 'text',
                'display_name' => 'Paket Adı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            array (
                'id' => 64,
                'data_type_id' => 9,
                'field' => 'slug',
                'type' => 'hidden',
                'display_name' => 'Paket Slug',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"slugify":{"origin":"name","forceUpdate":true}}',
                'order' => 3,
            ),
            array (
                'id' => 65,
                'data_type_id' => 9,
                'field' => 'price',
                'type' => 'text',
                'display_name' => 'Tutarı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 66,
                'data_type_id' => 9,
                'field' => 'about',
                'type' => 'markdown_editor',
                'display_name' => 'Paket Hakkında',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 67,
                'data_type_id' => 9,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Durumu',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"0":"Pasif","1":"Aktif"}}',
                'order' => 6,
            ),
            array (
                'id' => 68,
                'data_type_id' => 9,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Eklenme Tarihi',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 69,
                'data_type_id' => 9,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 8,
            ),
            array (
                'id' => 70,
                'data_type_id' => 9,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Silinme Zamanı',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 9,
            ),
            array (
                'id' => 71,
                'data_type_id' => 10,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 72,
                'data_type_id' => 10,
                'field' => 'member_id',
                'type' => 'text',
                'display_name' => 'Member Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 73,
                'data_type_id' => 10,
                'field' => 'plan_id',
                'type' => 'text',
                'display_name' => 'Plan Id',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 74,
                'data_type_id' => 10,
                'field' => 'payment_at',
                'type' => 'timestamp',
                'display_name' => 'Ödeme Zamanı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            array (
                'id' => 75,
                'data_type_id' => 10,
                'field' => 'start_at',
                'type' => 'timestamp',
                'display_name' => 'Paket Başlangıç Zamanı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 76,
                'data_type_id' => 10,
                'field' => 'finish_at',
                'type' => 'timestamp',
                'display_name' => 'Paket Bitiş Zamanı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            array (
                'id' => 77,
                'data_type_id' => 10,
                'field' => 'status',
                'type' => 'select_dropdown',
                'display_name' => 'Durumu',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"0":"Pasif","1":"Aktif"}}',
                'order' => 9,
            ),
            array (
                'id' => 78,
                'data_type_id' => 10,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Eklenme Tarihi',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            array (
                'id' => 79,
                'data_type_id' => 10,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 11,
            ),
            array (
                'id' => 80,
                'data_type_id' => 10,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Silinme Zamanı',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 12,
            ),
            array (
                'id' => 81,
                'data_type_id' => 10,
                'field' => 'membership_belongsto_membership_plan_relationship',
                'type' => 'relationship',
                'display_name' => 'Paket Adı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\MembershipPlan","table":"membership_plans","type":"belongsTo","column":"plan_id","key":"id","label":"name","pivot_table":"c_aggrements","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            array (
                'id' => 82,
                'data_type_id' => 10,
                'field' => 'membership_belongsto_member_relationship',
                'type' => 'relationship',
                'display_name' => 'Firma Adı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Member","table":"members","type":"belongsTo","column":"member_id","key":"id","label":"firstname","pivot_table":"c_aggrements","pivot":"0","taggable":"0"}',
                'order' => 3,
            ),
            array (
                'id' => 83,
                'data_type_id' => 9,
                'field' => 'credit',
                'type' => 'text',
                'display_name' => 'Kredi Miktarı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Adet Miktar\\u0131n\\u0131 giriniz."}',
                'order' => 5,
            ),
            array (
                'id' => 121,
                'data_type_id' => 15,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 122,
                'data_type_id' => 15,
                'field' => 'member_id',
                'type' => 'text',
                'display_name' => 'Member Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 2,
            ),
            array (
                'id' => 123,
                'data_type_id' => 15,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'Title',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            array (
                'id' => 124,
                'data_type_id' => 15,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Job Id',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 125,
                'data_type_id' => 15,
                'field' => 'date',
                'type' => 'text',
                'display_name' => 'Date',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 126,
                'data_type_id' => 15,
                'field' => 'about',
                'type' => 'text',
                'display_name' => 'About',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 6,
            ),
            array (
                'id' => 127,
                'data_type_id' => 15,
                'field' => 'location',
                'type' => 'text',
                'display_name' => 'Location',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 128,
                'data_type_id' => 15,
                'field' => 'example_video_link',
                'type' => 'text',
                'display_name' => 'Example Video Link',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            array (
                'id' => 129,
                'data_type_id' => 15,
                'field' => 'created_ip',
                'type' => 'text',
                'display_name' => 'Created Ip',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            array (
                'id' => 130,
                'data_type_id' => 15,
                'field' => 'active',
                'type' => 'text',
                'display_name' => 'Active',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 10,
            ),
            array (
                'id' => 131,
                'data_type_id' => 15,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Created At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 11,
            ),
            array (
                'id' => 132,
                'data_type_id' => 15,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Updated At',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 12,
            ),
            array (
                'id' => 133,
                'data_type_id' => 15,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Deleted At',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 13,
            ),
            array (
                'id' => 134,
                'data_type_id' => 17,
                'field' => 'id',
                'type' => 'text',
                'display_name' => 'Id',
                'required' => 1,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 1,
            ),
            array (
                'id' => 135,
                'data_type_id' => 17,
                'field' => 'member_id',
                'type' => 'text',
                'display_name' => 'İşveren',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 3,
            ),
            array (
                'id' => 136,
                'data_type_id' => 17,
                'field' => 'title',
                'type' => 'text',
                'display_name' => 'İlan Başlığı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 4,
            ),
            array (
                'id' => 137,
                'data_type_id' => 17,
                'field' => 'job_id',
                'type' => 'text',
                'display_name' => 'Meslek Grubu',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 5,
            ),
            array (
                'id' => 138,
                'data_type_id' => 17,
                'field' => 'date',
                'type' => 'date',
                'display_name' => 'İşin Tarihi',
                'required' => 1,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 7,
            ),
            array (
                'id' => 139,
                'data_type_id' => 17,
                'field' => 'about',
                'type' => 'text_area',
                'display_name' => 'İş Hakkında',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 8,
            ),
            array (
                'id' => 140,
                'data_type_id' => 17,
                'field' => 'location',
                'type' => 'text',
                'display_name' => 'Lokasyon',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 9,
            ),
            array (
                'id' => 141,
                'data_type_id' => 17,
                'field' => 'example_video_link',
                'type' => 'text',
            'display_name' => 'Görsel (Video)',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"Video Amazon S3 e y\\u00fcklenip, linki yap\\u0131\\u015ft\\u0131r\\u0131lmal\\u0131d\\u0131r."}',
                'order' => 10,
            ),
            array (
                'id' => 142,
                'data_type_id' => 17,
                'field' => 'created_ip',
                'type' => 'text',
                'display_name' => 'Oluşturan IP',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{}',
                'order' => 12,
            ),
            array (
                'id' => 143,
                'data_type_id' => 17,
                'field' => 'active',
                'type' => 'select_dropdown',
                'display_name' => 'Durumu',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"default":"1","options":{"0":"Pasif","1":"Aktif"}}',
                'order' => 13,
            ),
            array (
                'id' => 144,
                'data_type_id' => 17,
                'field' => 'created_at',
                'type' => 'timestamp',
                'display_name' => 'Oluşturma Zamanı',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 14,
            ),
            array (
                'id' => 145,
                'data_type_id' => 17,
                'field' => 'updated_at',
                'type' => 'timestamp',
                'display_name' => 'Son Güncellenme',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 0,
                'details' => '{}',
                'order' => 15,
            ),
            array (
                'id' => 146,
                'data_type_id' => 17,
                'field' => 'deleted_at',
                'type' => 'timestamp',
                'display_name' => 'Silinme Zamanı',
                'required' => 0,
                'browse' => 0,
                'read' => 0,
                'edit' => 0,
                'add' => 0,
                'delete' => 1,
                'details' => '{}',
                'order' => 16,
            ),
            array (
                'id' => 147,
                'data_type_id' => 17,
                'field' => 'postx_belongsto_member_relationship',
                'type' => 'relationship',
                'display_name' => 'İşveren',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\Member","table":"members","type":"belongsTo","column":"member_id","key":"id","label":"company_title","pivot_table":"c_aggrements","pivot":"0","taggable":"0"}',
                'order' => 2,
            ),
            array (
                'id' => 148,
                'data_type_id' => 17,
                'field' => 'postx_belongsto_c_job_relationship',
                'type' => 'relationship',
                'display_name' => 'Meslek Grubu',
                'required' => 0,
                'browse' => 1,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"model":"App\\\\CJob","table":"c_jobs","type":"belongsTo","column":"job_id","key":"id","label":"value","pivot_table":"c_aggrements","pivot":"0","taggable":"0"}',
                'order' => 6,
            ),
            array (
                'id' => 149,
                'data_type_id' => 17,
                'field' => 'example_photo_link',
                'type' => 'image',
            'display_name' => 'Görsel (Fotoğraf)',
                'required' => 0,
                'browse' => 0,
                'read' => 1,
                'edit' => 1,
                'add' => 1,
                'delete' => 1,
                'details' => '{"description":"\\u00d6l\\u00e7\\u00fcleri minimum 1000x1000 piksel olmal\\u0131d\\u0131r. Kare formatta olmal\\u0131d\\u0131r."}',
                'order' => 11,
            ),
        ));
    }
}
