<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('post_applications', function (Blueprint $table) {
            $table->id();
            $table->integer('post_id')->nullable();
            $table->unsignedInteger('creator_id')->nullable();
            $table->text('video_link')->nullable();
            $table->string('apply_ip', 30)->nullable();
            $table->string('status', 1)->nullable()->default('0');
            $table->timestamp('approved_at')->nullable();
            $table->string('approved_ip', 50)->nullable();
            $table->timestamp('rejected_at')->nullable();
            $table->string('rejected_ip', 50)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('post_applications');
    }
};
