<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('members', function (Blueprint $table) {
            $table->id();
            $table->string('type', 1)->nullable()->default('1')->comment('1=Calisan,2=Isveren');
            $table->string('company_title', 150)->nullable();
            $table->string('firstname', 150)->nullable();
            $table->string('surname', 100)->nullable();
            $table->string('email', 250)->nullable();
            $table->string('password', 250)->nullable();
            $table->string('phone', 15)->nullable();
            $table->unsignedInteger('credit')->nullable()->default(0);
            $table->string('lang', 3)->nullable()->default('tr');
            $table->string('active', 1)->nullable()->default('1');
            $table->string('token', 256)->nullable();
            $table->string('ip', 60)->nullable();
            $table->string('last_login_ip', 60)->nullable();
            $table->timestamp('last_login')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('members');
    }
};
