<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_profiles', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id')->nullable();
            $table->string('school_id', 11)->nullable();
            $table->string('city_id', 11)->nullable();
            $table->string('town_id', 11)->nullable();
            $table->string('job_id', 11)->nullable();
            $table->text('related_jobs')->nullable();
            $table->text('photo_link')->nullable();
            $table->string('gender', 11)->nullable();
            $table->text('about')->nullable();
            $table->string('loc_lat', 35)->nullable();
            $table->string('loc_lng', 35)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_profiles');
    }
};
