<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('member_otps', function (Blueprint $table) {
            $table->id();
            $table->integer('member_id')->nullable();
            $table->string('type', 1)->nullable()->default('1');
            $table->string('code', 5)->nullable();
            $table->string('to', 250)->nullable();
            $table->string('activated', 1)->nullable()->default('0');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('member_otps');
    }
};
