<?php

namespace App;
use DB;
use App\CJob;
use App\Member;
use App\MemberStory;
use App\MemberCreditHistory;

class Outsource
{

  public static function checkToken($token)
  {
    $check = DB::table('members')->where('token',$token)->first();
    if(isset($check->id))
    {
      return $check->id;
    }
      return false;

  }

  public static function get_meters_between_points($latitude1, $longitude1, $latitude2, $longitude2) {
  	if (($latitude1 == $latitude2) && ($longitude1 == $longitude2)) { return 0; } // distance is zero because they're the same point
  	$p1 = deg2rad($latitude1);
  	$p2 = deg2rad($latitude2);
  	$dp = deg2rad($latitude2 - $latitude1);
  	$dl = deg2rad($longitude2 - $longitude1);
  	$a = (sin($dp/2) * sin($dp/2)) + (cos($p1) * cos($p2) * sin($dl/2) * sin($dl/2));
  	$c = 2 * atan2(sqrt($a),sqrt(1-$a));
  	$r = 6371008; // Earth's average radius, in meters
  	$d = $r * $c;
  	return $d; // distance, in meters
  }


  public static function haversineDistance($lat1, $lon1, $lat2, $lon2, $unit = 'K') {
    $theta = $lon1 - $lon2;
    $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
    $dist = acos($dist);
    $dist = rad2deg($dist);
    $miles = $dist * 60 * 1.1515;
    $unit = strtoupper($unit);

    if ($unit == "K") {
      return round(($miles * 1.609344),2);
    } else if ($unit == "N") {
        return ($miles * 0.8684);
      } else {
          return $miles;
        }
  }

  public static function getCompanyDetail($id)
  {
    $find = Member::find($id);

    return $find;
  }

  public static function getJobDetail($id)
  {
    $find = CJob::find($id);

    return $find;
  }

  public static function getStory($id)
  {
    $find = MemberStory::where('member_id',$id)->orderBy('id','desc')->first();
    return $find;
  }

  public static function getSchool($t)
  {
    if($t=='1')
    {
      return 'İlkokul';
    }elseif($t=='2'){
      return 'Ortaokul';
    }elseif($t=='3'){
      return 'Lise';
    }elseif($t=='4'){
      return 'Lisans';
    }else{
      return 'Yüksek Lisans';
    }
  }
  public static function getGender($t)
  {
    if($t=='male')
    {
      return 'Erkek';
    }else{
      return 'Kadın';
    }
  }

  public static function sendSMS($phone,$msg)
  {
    $username = "fedijital";
    $password = "Xm2GxpXe";



    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://panel2.evyapanltd.com.tr:9587/sms/create-otp',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
        "type": 1,
        "sendingType": 0,
        "title": "'.uniqid().'",
        "content": "'.$msg.'",
        "number": '.$phone.',
        "sender": "FeDijital",
        "periodicSettings": null,
        "sendingDate": null,
        "commercial":false,
        "encoding": 0,
        "validity": 3,
        "pushSettings": null
    }',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic '.base64_encode($username.':'.$password),
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    return json_decode($response,true);
  }

  public static function sendSingleSms($phone,$msg){

    $username = "fedijital";
    $password = "Xm2GxpXe";

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => 'http://panel2.evyapanltd.com.tr:9587/sms/create',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS =>'{
        "type": 1,
        "sendingType": 0,
        "title": "'.uniqid().'",
        "content": "'.$msg.'",
        "number": '.$phone.',
        "encoding": 0,
        "sender": "FeDijital",
        "periodicSettings": null,
        "sendingDate": null,
        "validity": 60,
        "pushSettings": null
    }',
      CURLOPT_HTTPHEADER => array(
        'Authorization: Basic '.base64_encode($username.':'.$password),
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    return json_decode($response,true);

  }

  public static function expenseCredit($member_id,$process,$worker_id=NULL)
  {
      $member = Member::find($member_id);

      if($process=='create_ad'){
        $title="İlan Oluşturma";
        $amount = DB::table('settings')->where('id','35')->first()->value;
      }elseif($process=='view_profile'){
        $title="Profil Görüntüleme";
        $amount = DB::table('settings')->where('id','34')->first()->value;
      }
      $date = date('Y-m-d H:i:s');
      $trans_id = uniqid();

      if($member->credit+1 > $amount)
      {

        // Kredi harcamasını kayıtlara ekle
        $history = array('employer_id'=>$member_id,'worker_id'=>$worker_id,'transaction_id'=>$trans_id,'title'=>$title,'type'=>'expense','amount'=>$amount,'created_at'=>$date);
        $add_history = MemberCreditHistory::insert($history);

        // Kredi harcamasını yaptır
        $new_credit = $member->credit - $amount;
        $member_update = Member::where('id',$member_id)->update(['credit'=>$new_credit,'updated_at'=>$date]);

        return true;

      }

      return false;

  }

  public static function setLog()
  {

  }

}
