<?php

namespace App\Http\Controllers;

use App\Member;
use App\MemberCreditHistory;
use App\MemberExperience;
use App\MemberOtp;
use App\MemberProfile;
use App\MemberStory;
use App\Outsource;
use Illuminate\Support\Facades\DB;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use TCG\Voyager\Models\Post;

class ProfileController extends Controller
{
    public function getPreProfile(Request $request,$id)
    {
        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {

              $checkHistory = MemberCreditHistory::where('employer_id',$check)->where('worker_id',$id)->count();
              if($checkHistory > 0)
              {
                $history = true;
              }else{
                $history = false;
              }
              $basic=Member::find($id);
              $detail=MemberProfile::where('member_id',$id)->first();
              @$name = $basic->firstname.' '.$basic->surname;
              @$about = $detail->about;
              @$story = Outsource::getStory($check)->video_link;
              @$school_text = Outsource::getSchool($detail->school_id);
              @$related_jobs = json_decode($detail->related_jobs);

              @$job = array();
              if(isset($related_jobs))
              {
                foreach($related_jobs as $rj)
                {
                  @$job[] = Outsource::getJobDetail($rj)->value;
                }
              }

              $list = MemberExperience::where('member_id',$id)->whereNull('deleted_at')->get();
              $result = [];

              foreach($list as $key=>$li)
              {
                $result[$key]['id'] = $li->id;
                $result[$key]['company'] = $li->company;
                $result[$key]['job_id'] = $li->job_id;
                $result[$key]['job_title'] = Outsource::getJobDetail($li->job_id)->value;
                $result[$key]['duration'] = $li->duration;
              }


              $detail = array('history'=>$history,'photo_link'=>@$detail->photo_link,'school'=>$school_text,'related_jobs'=>$job,'story'=>$story,'name'=>$name,'about'=>$about,'experiences'=>$result);
              return response()->json(array('status'=>true,'basic'=>$basic,'detail'=>$detail));

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, tekrar sisteme giriş yapınız.'));
        }
    }

    public function profile(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
          $basic=Member::find($check);
          $detail=MemberProfile::where('member_id',$check)->first();
          @$job_id = Outsource::getJobDetail($detail->job_id)->value;
          @$gender_text = Outsource::getGender($detail->gender);
          @$school_text = Outsource::getSchool($detail->school_id);
          @$story = Outsource::getStory($check)->video_link;
          @$related_jobs = json_decode($detail->related_jobs);
          @$detail=array('photo_link'=>$detail->photo_link,
                          'job_usage_id'=>$detail->job_id,
                          'job_id'=>$job_id,
                          'school_id'=>$detail->school_id,
                          'school_text'=>$school_text,
                          'gender'=>$detail->gender,
                          'gender_text'=>$gender_text,
                          'related_jobs'=>$related_jobs,
                          'story'=>$story,
                          'example_video_url'=>setting('site.example_video_url')
                        );
          return response()->json(array('status'=>true,'basic'=>$basic,'detail'=>$detail));

      }else{

        return response()->json(array('status'=>false,'message'=>'Lütfen, tekrar sisteme giriş yapınız.'));
      }
    }


    public function profileVideoUpdate(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'video_link' => 'required',
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $input = $request->all();

          $update = MemberStory::insert(['member_id'=>$check,
                                         'video_link'=>$request->get('video_link'),
                                       'active'=>'1',
                                     'created_ip'=>$_SERVER['REMOTE_ADDR'],
                                   'created_at'=>date('Y-m-d H:i:s')]);

          return response()->json(array('status'=>true,'message'=>'Profil videosu başarıyla yüklenmiştir.'));

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function profilePhotoUpdate(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'photo_link' => 'required',
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $input = $request->all();

          $update = MemberProfile::where('member_id',$check)
                                  ->update($input);

          return response()->json(array('status'=>true,'message'=>'Profiliniz başarıyla güncellenmiştir.'));

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function profileUpdate(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'school_id' => 'required',
          'gender' => 'required',
          'loc_lat' => 'required',
          'loc_lng' => 'required',
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $kontrol = MemberProfile::where('member_id',$check)->count();

          if($kontrol > 0)
          {
            $input = $request->all();
            $update = MemberProfile::where('member_id',$check)
                                  ->update($input);
          }else{
            $request->request->add(['member_id' => $check]);

            $input = $request->all();
            $update = MemberProfile::insert($input);
          }

          return response()->json(array('status'=>true,'message'=>'Profiliniz başarıyla güncellenmiştir.'));

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function profileDeleteAccount(Request $request)
    {
      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {

        $date = date('Y-m-d H:i:s');
        $profile_otp_delete = MemberOtp::where('member_id',$check)->update(['activated'=>'0','deleted_at'=>$date]);
        $member_profile_delete = MemberProfile::where('member_id',$check)->update(['deleted_at'=>$date]);
        @$profile = Member::find($check);

        if($profile->type=='2')
        {
          @$posts_delete = Post::where('member_id',$check)->update(['active'=>'0','deleted_at'=>$date]);
        }

        $profile_delete = Member::where('id',$check)->update(['active'=>'0','deleted_at'=>$date]);



          return response()->json(array('status'=>true,'message'=>'Hesabınız pasif hale getirilmiştir. 7 gün içerisinde sistem içerisindeki tüm verileriniz silinecektir.'));
      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function profileCompletedEmployer(Request $request)
    {
        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {
            $kontrol = MemberProfile::where('member_id',$check)->count();

            if($kontrol > 0)
            {
              $input = $request->all();
              $request->request->remove('company_title');
              $update = MemberProfile::where('member_id',$check)
                                    ->update($input);
            }else{
              $update = Member::where('id',$check)->update(['company_title'=>$request->get('company_title')]);

              $request->request->add(['member_id' => $check]);
              $request->request->remove('company_title');
              $input = $request->all();
              $update = MemberProfile::insert($input);

            }

            return response()->json(array('status'=>true,'message'=>'Profiliniz başarıyla güncellenmiştir.'));


        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }

    }

    public function profilePasswordUpdate(Request $request)
    {

          $token = $request->header('token');
          $check = Outsource::checkToken($token);
          if($check)
          {
            $validator = Validator::make($request->all(),
            [
              'old_password' => 'required',
              'new_password' => 'required',
              'new_password_again' => 'required'
            ],[
              'required' => '* Gerekli alan'
            ]);

            if ($validator->fails()) {
              return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
            }else{
              $user = Member::find($check);

              if (!(Hash::check($request->get('old_password'), $user->password))) {
                  return response()->json(array('status'=>false,'message'=>'Eski şifreniz sistemdekiyle uyuşmuyor.'));
              }else{
                if($request->get('new_password') != $request->get('new_password_again'))
                {
                    return response()->json(array('status'=>false,'message'=>'Yeni şifreler aynı değildir.'));
                }else{

                  $update = Member::where('id',$check)->update([
                                                    'password'=>Hash::make($request->get('new_password_again')),
                                                    'updated_at'=>date('Y-m-d H:i:s')
                                                  ]);

                  return response()->json(array('status'=>true,'message'=>'Şifreniz başarıyla güncellenmiştir.'));
                }

              }
            }

          }else{
            return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
          }
    }
}
