<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\DB;
use App\Member;
use App\MemberCreditHistory;

class PaymentController extends Controller
{
    public function paymentIframe($planId,$token)
    {
      $plan = DB::table('membership_plans')->where('id',$planId)->first();
      $member = DB::table('members')->where('token',$token)->first();

      @$delete_old_orders = DB::table('membership_payments')->where('status','1')->update(['deleted_at'=>date('Y-m-d H:i:s')]);

        $orderId = date('Ymd').uniqid();
        $create_payment = DB::table('membership_payments')
                              ->insert([
                                'member_id'=>$member->id,
                                'plan_id'=>$planId,
                                'order_id'=>$orderId,
                                'credit'=>$plan->credit,
                                'amount'=>$plan->price,
                                'status'=>'1',
                                'created_at'=>date('Y-m-d H:i:s')
                              ]);

        return view('paytr-iframe',array('plan'=>$plan,'orderId'=>$orderId,'member'=>$member));

    }

    public function paymentResponse($type)
    {
      if($type=='success'){
        return 'Başarılı';
      }else{
        return 'Hatalı İşlem';
      }
    }

    public function paytrResult()
    {
      $post = $_POST;

      $date = date('Y-m-d H:i:s');

      $merchant_key 	= 'wSv9bh4E16KPFDo7';
      $merchant_salt	= 'ruFEcz23XXei1KhK';
      $hash = base64_encode( hash_hmac('sha256', $post['merchant_oid'].$merchant_salt.$post['status'].$post['total_amount'], $merchant_key, true) );
      if( $hash != $post['hash'] )
        die('PAYTR notification failed: bad hash');

      $check = DB::table('membership_payments')->where('order_id',$post['merchant_oid'])->first();

      if(@$check->deleted_at!=NULL || $check->status=='0' || $check->status=='2')
      {
        echo 'OK';
        exit;
      }else{
        if( $post['status'] == 'success' ) {

          $order_detail = DB::table('membership_payments')->where('order_id',$post['merchant_oid'])->first();

          $credit = $order_detail->credit;

          $history = array('employer_id'=>$order_detail->member_id,'worker_id'=>NULL,'transaction_id'=>$post['merchant_oid'],'title'=>'Kredi Yüklemesi','type'=>'income','amount'=>$order_detail->amount,'created_at'=>$date);
          @$add_history = MemberCreditHistory::insert($history);

          $member = Member::find($order_detail->member_id);
          $credit = $member->credit;
          $new_credit = $credit + $order_detail->credit;

          @$update_member = Member::where('id',$member->id)->update(['credit'=>$new_credit,'updated_at'=>$date]);

          @$update_order = DB::table('membership_payments')
                      ->where('order_id',$post['merchant_oid'])
                      ->update([
                        'status'=>'2',
                        'updated_at'=>$date
                      ]);

        }else{
          $array = array('code'=>$post['failed_reason_code'],'msg'=>$post['failed_reason_msg']);
          $update = DB::table('membership_payments')
                      ->where('order_id',$post['merchant_oid'])
                      ->update([
                        'status'=>'0',
                        'updated_at'=>$date,
                        'reject_reason'=>json_encode($array)
                      ]);
        }
      }

        echo "OK";
        exit;
    }
}
