<?php

namespace App\Http\Controllers;

use App\CJob;
use App\MemberExperience;
use App\Outsource;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
class JobController extends Controller
{
    public function createJobExperience(Request $request)
    {

        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {
          $validator = Validator::make($request->all(),
          [
            'company' => 'required',
            'job_id' => 'required',
            'duration' => 'required'
          ],[
            'required' => '* Gerekli alan'
          ]);

          if ($validator->fails()) {
            return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
          }else{

            $request->request->add(['member_id' => $check,'created_ip'=>$_SERVER['REMOTE_ADDR']]);

            $input = $request->all();
            $update = MemberExperience::insert($input);

            return response()->json(array('status'=>true,'message'=>'İş Tecrübeniz başarıyla eklenmiştir.'));

          }

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }
    }

    public function updateJobExperience(Request $request)
    {

      $token = $request->header('token');
      $check = Outsource::checkToken($token);
      if($check)
      {
        $validator = Validator::make($request->all(),
        [
          'company' => 'required',
          'job_id' => 'required',
          'duration' => 'required'
        ],[
          'required' => '* Gerekli alan'
        ]);

        if ($validator->fails()) {
          return response()->json($validator->messages(), Response::HTTP_BAD_REQUEST);
        }else{

          $input = $request->all();

          $update = MemberExperience::where('id',$request->get('id'))->update($input);

          return response()->json(array('status'=>true,'message'=>'İş Tecrübeniz başarıyla güncellenmiştir.'));

        }

      }else{
        return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
      }
    }

    public function deleteJobExperience(Request $request,$id)
    {

        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {

          if(is_numeric($id))
          {
            $delete = MemberExperience::where('id',$id)->update([
              'deleted_at'=>date('Y-m-d H:i:s')
            ]);

            return response()->json(array('status'=>true,'message'=>'İş Tecrübeniz başarıyla silinmiştir.'));
          }

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }
    }

    public function listJobExperience(Request $request)
    {
        $token = $request->header('token');
        $check = Outsource::checkToken($token);
        if($check)
        {

          $list = MemberExperience::where('member_id',$check)->whereNull('deleted_at')->get();
          $result = [];

          foreach($list as $key=>$li)
          {
            $result[$key]['id'] = $li->id;
            $result[$key]['company'] = $li->company;
            $result[$key]['job_id'] = $li->job_id;
            $result[$key]['job_title'] = Outsource::getJobDetail($li->job_id)->value;
            $result[$key]['duration'] = $li->duration;
          }

          return response()->json(array('status'=>true,'message'=>'İş tecrübeniz listelenmiştir.','data'=>$result));

        }else{
          return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
        }
    }

    public function getJobList(Request $request)
  {
    $token = $request->header('token');
    $check = Outsource::checkToken($token);
    if($check)
    {

      $list = CJob::whereNull('deleted_at')->orderBy('id','desc')->get();
      $result=[];
      foreach($list as $key=>$li)
      {
        $result[$key]['name']=$li->value;
        $result[$key]['label']=$li->value;
        $result[$key]['value']=$li->id;
        $result[$key]['id']=$li->id;
      }

      $respon=[];
      foreach($list as $key=>$li)
      {
        $respon[$key]['name']=$li->value;
        $respon[$key]['id']=$li->id;
      }


      $details=[];
      foreach($list as $key=>$li)
      {
        $respon[$key]['label']=$li->value;
        $respon[$key]['value']=$li->id;
      }
      return response()->json(array('status'=>true,'message'=>'Sistemdeki meslekler listelenmiştir.','data'=>$result,'response'=>$respon,'details'=>$details));

    }else{
      return response()->json(array('status'=>false,'message'=>'Lütfen, sisteme tekrar giriniz.'));
    }
  }
}
