<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class FirstSetupCommands extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'setup:run';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'First Setup Commands';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        Artisan::call('migrate');

        DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        Artisan::call('db:seed');
        Artisan::call('db:seed PermissionsTableSeeder');

        DB::statement('SET FOREIGN_KEY_CHECKS=1;');

        $this->info('İşlem Tamamlandı!');
    }
}
